#ifndef __CVstWindow__
#define __CVstWindow__


//	===========================================================================

#include <audioeffectx.h>
#ifdef VST_2_4_EXTENSIONS
#include <aeffeditor.h>
#else
#include <AEffEditor.hpp>
#endif
#include <Host/CApplication.hpp>
#include <Listeners/IActionListener.hpp>
#include <Windowing/CWindow.hpp>
#include <Threading/CCriticalSectionScope.hpp>

//	===========================================================================

using Exponent::GUI::Windowing::CWindow;
using Exponent::Host::CApplication;
using Exponent::GUI::Listeners::IActionListener;
using Exponent::Threading::CCriticalSectionScope;

//	===========================================================================

namespace Exponent
{
	namespace Vst
	{
		/**
		 * @class CVstWindow CVstWindow.hpp
		 * @brief A VST specific window class
		 *
		 * @date 22/04/2005
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 * @version 1.0.1 Added Keyoard hook through root
		 * @version 1.0.2 Converted to VST 2.4 compatiblity
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 * Please note that VST is copyright Steinberg Media GmBh. No challenge is made to any of their trademarks
		 * To use this file, you require a copy of the VST SDK, available from www.steinberg.net for free
		 *
		 * $Id: CVstWindow.hpp,v 1.6 2007/02/27 19:47:38 paul Exp $
		 */
		class CVstWindow : public AEffEditor, public CWindow, public IActionListener, public IKeyboardListener
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 * @param theEffect The effect tied to this editor
			 * @param windowArea Size of the editor
			 * @param attributes Attributes of the window
			 */
			CVstWindow(AudioEffect *theEffect, const CRect &windowArea, CWindowAttributes *attributes);

			/**
			 * Destruction
			 */
			virtual ~CVstWindow();

//	===========================================================================

			/**
			 * Get the area of the window
			 * @param rect The rectangle to fill
			 * @retval bool 1 On scuess, 0 otherwise..
			 */
#ifdef VST_2_4_EXTENSIONS
			virtual bool getRect(ERect **rect);
#else
			virtual long getRect(ERect **rect);
#endif

			/**
			 * Update the window
			 */
			virtual void update();

//	===========================================================================

			/**
			 * Block updates
			 * @param block If true all drawing updates are prevented from happening, if false, drawing is allowed as normal
			 */
			void blockUpdates(const bool block) { m_blockUpdates = block; }

			/**
			 * Set an area of the window dirty
			 * @param area The area to redraw
			 */
			virtual void redrawWindow(const CRect &area);

			/**
			 * Set the whole window dirty - generally use sparingly!!
			 */
			virtual void redrawWindow();

//	===========================================================================

			/**
			 * Open the window -> You should override and then call startVSTWindow
			 * @param windowHandle Parent window handle
			 * @retval bool True if opened properly, false otherwise
			 */
#ifdef VST_2_4_EXTENSIONS
			virtual bool open(void *windowHandle);
#else
			virtual long open(void *windowHandle);
#endif

			/**
			 * Close the window
			 */
			virtual void close();

			/**
			 * Start (initialise) the VSTWindow
			 * @see open
			 */
			virtual void startVSTWindow();

			/**
			 * Silly VST Idle function
			 */
			virtual void idle();

//	===========================================================================

			/**
			 * Handle action events
			 * @param event The action event to handle
			 */
			virtual void handleActionEvent(const CActionEvent &event);

			/**
			 * Set parameter
			 * @param index The index of the parameter to set
			 * @param value The value of the parameter to set
			 */
			virtual void setParameter(const long index, const double value);

//	===========================================================================

			/**
			 * Parameter is set from the editor
			 * @retval bool If true user has adjusted on screen control, if false the change is programmatic and the GUI should be redrawn
			 */
			virtual bool parameterSetFromEditor() const { return m_setFromEditor; }

			/**
			 * Parameter is being set from the editor
			 * @param setFromEditor If true user has adjusted on screen control, if false the change is programmatic and the GUI should be redrawn
			 */
			virtual void parameterIsBeingSetFromEditor(const bool setFromEditor = true) { m_setFromEditor = setFromEditor; }

//	===========================================================================

			/**
			 * Handle key down events
			 * @param event The event to handle
			 * @retval bool TRue if handled, false otherwise
			 */
			virtual bool handleKeyDown(const CKeyboardEvent &event);

			/**
			 * Handle key up events
			 * @param event The event to handle
			 * @retval bool TRue if handled, false otherwise
			 */
			virtual bool handleKeyUp(const CKeyboardEvent &event);

//	===========================================================================
			#if MAC
				/**
				 * Silly VST draw function
				 * @param rect The update area
				 */
				virtual void draw (ERect *rect);
			#endif

			#ifndef WIN32
				/**
				 * Get window offset
				 * @retval CPoint* The offset area of the internal child window
				 */
				virtual CPoint getWindowOffset();
			#endif

//	===========================================================================

		protected:

//	===========================================================================

			/**
			 * @class CParentWindow CVstWindow.hpp
			 * @brief Inner clas that represents a parent window
			 */
			class CParentWindow : public CWindow
			{
			public:

				/**
				 * Construction
				 * @param windowHandle Parent Window handle
				 */
				CParentWindow(void *windowHandle);

				/**
				 * Destruction
				 */
				virtual ~CParentWindow();


				SWindowHandle *m_myParentWindowHandle;		/**< The actual window handle */
			};

//	===========================================================================

			/**
			 * Create the vst window
			 * @param windowHandle Parent window handle
			 */
			virtual void createVSTWindow(void *windowHandle);

			/**
			 * Destroy the vst window
			 */
			virtual void destroyVSTWindow();

			#ifndef WIN32
				/**
				 * Handle window events
				 * @param handler The event handler call back
				 * @param theEvent The event to handle
				 * @retval OSStatus Did the operation process properly?
				 */
				virtual pascal OSStatus handleVstWindowEvents(EventHandlerCallRef handler, EventRef theEvent);

				/**
				 * Handle window events
				 * @param handler The event handler call back
				 * @param theEvent The event to handle
				 * @param userData Pointer to the window to pass the event to
				 * @retval OSStatus Did the operation process properly?
				 */
				static pascal OSStatus VSTWindowProc(EventHandlerCallRef handler, EventRef theEvent, void *userData);
				
				/**
				 * Handle HIView control events
				 * @param handler The event handler call back
				 * @param theEvent The event to handle
				 * @retval OSStatus Did the operation process properly?
				 */
				virtual pascal OSStatus handleHIViewControlEvents(EventHandlerCallRef handler, EventRef theEvent);
				
				/**
				 * Handle the HIView control events
				 * @param handler The event handler call back
				 * @param theEvent The event to handle
				 * @param userData Pointer to the window to pass the event to
				 * @retval OSStatus Did the operation process properly?
				 */
				static pascal OSStatus HIViewControlProc(EventHandlerCallRef handler, EventRef theEvent, void *userData);
				
				/**
				 * Get the user pane, potentially NULL
				 * @retval HIViewRef The user pane
				 */
				HIViewRef getUserPane() { return m_userPane; }
				
				/**
				 * @class CVstWindowTimer CVstWindow
				 * @brief Timer for redraw / idle events
				 */
				class CVstWindowTimer : public ITimedObject
				{
				public:
				
					/**
					 * Construction
					 * @param window The window to time
					 */
					CVstWindowTimer(CVstWindow *window);
					
					/**
					 * Destruction
					 */
					virtual ~CVstWindowTimer();

					/**
					 * Notification of your timer expiring
					 */
					virtual void timerExpired();

					/**
					 * Get the id 
					 * @retval long The unique Timer id
					 * @note Negative numbers are reserved for system classes. Use positive numbers ONLY!!
					 */
					virtual long getTimerId() const { return -5000; }
					
				protected:
				
					CVstWindow *m_window;			/**< The window that is being timed */
				};
			#endif

//	===========================================================================

			CParentWindow *m_theVSTParentWindow;				/**< The parent window handle */
			bool m_setFromEditor;								/**< Is the change from the editor? */
			bool m_blockUpdates;								/**< Should we allow updates? */
			ERect m_myRect;										/**< Stupid VST rect that is required */

			#ifndef WIN32
				CCriticalSection *m_idleSection;				/**< Critical section for graphics idle */
				HIViewRef m_userPane;							/**< Hiview ref for the user pane */
				HIViewRef m_contentPane;						/**< Root level HIViewRef for the window */
				CVstWindowTimer *m_windowTimer;					/**< The window timer */
			#endif

//	===========================================================================
		};
	}
}
#endif	// End of CVstWindow.hpp